<?php
/*--------------------------------------------------------------
   Map.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

use Gambio\Admin\Modules\Statistics\Model\Collections\MapItems;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

class Map implements Data
{
    /**
     * @var MapItems
     */
    private $mapItems;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(MapItems $mapItems)
    {
        $this->mapItems = $mapItems;
        $this->type     = 'map';
    }
    
    
    /**
     * Create instance.
     */
    public static function create(MapItems $mapItems): self
    {
        return new self($mapItems);
    }
    
    
    /**
     * Return map items.
     */
    public function mapItems(): MapItems
    {
        return $this->mapItems;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
}